﻿/*
	VERSION:		1.92
	1.92		Added inline scope to setTimeouts
	1.91		Added a missing  _global.setTimeout
	
	
	NOTE:
		You can optionally specify a movieClip target.
		That way, only double-clicking that movieClip will trigger the double-click event.
		
		
	REMOVAL:
		doubleClick.shutDown();
		delete doubleClick;
		
		
	USAGE 1:
		doubleClick = new DoubleClick();
		doubleClick.onDoubleClick = function()
		{
			trace("double click");
		}
		
		
	USAGE 1b:
		doubleClick = new DoubleClick( my_mc );
		doubleClick.onDoubleClick = function()
		{
			trace("double click");
		}
	
	
	USAGE 2:
		doubleClick = new DoubleClick();
		doubleClick.addListener( this );
		this.onDoubleClick = function()
		{
			trace("double click");
		}
*/
class DoubleClick
{
	var maxDistance = 16;						// pixels.  How close the 2 clicks need to be to each other
	var maxDelay = 1000/4.5;				// milliseconds.  How fast the double-click needs to be, to be valid
	var oldX:Number;
	var oldY:Number;
	var broadcastMessage:Function;	// Allows events to be broadcast
	var onDoubleClick:Function;			// externally-defined function
	var delay;											// ID number used to cancel the delay timeout
	var target;											// movieClip to be clicked on
	var clickCount;									// keeps track of how many times you've clicked
	function DoubleClick( newTarget )
	{
		target = newTarget;
		AsBroadcaster.initialize( this );
		Mouse.addListener( this );
		oldX = 99999;
		oldY = 99999;
		clickCount = 0;
	}// CONSTRUCTOR
	function shutDown()
	{
		_global.clearTimeout( delay );
		Mouse.removeListener( this );
	}// PSEUDO-DESTRUCTOR		(does not remove the object)
	
	
	
	function onMouseUp()
	{
		var _this = this;
		// if this click is near the previous one  &  timeOut hasn't expired
		var isComponent = (target._name == "boundingBox_mc");
		var isEnabled = (isComponent) ? target._parent.enabled : true;		// component is enabled?
		var isVisible = (isComponent) ? target._parent.visible : true;		// component is visible?
		var targetClicked = (target) ? target.hitTest( _root._xmouse, _root._ymouse ) : true;
		if(targetClicked  &&  isEnabled  &&  isVisible)
		{// if:  target clicked
			clickCount++;
			
			
			if(clickCount == 1)
			{// if:  1st click
				// remember this click location
				oldX = _root._xmouse;
				oldY = _root._ymouse;
				// start waiting for double-click
				_global.clearTimeout( delay );
				delay = _global.setTimeout( function(){
					_this.timeOut();
				}, maxDelay );		// calls timeOut() 1/4 of a second later
			}// if:  1st click
			
			
			if(clickCount == 2)
			{// if:  2nd click
				// remember this click location
				var newX = _root._xmouse;
				var newY = _root._ymouse;
				// check distance
				var diffX = newX - oldX;
				var diffY = newY - oldY;
				oldX = 99999;
				oldY = 99999;
				var clickDistance = Math.sqrt( (diffX*diffX) + (diffY*diffY) );
				if( clickDistance < this.maxDistance )
				{// if:  near the location of the 1st click
					// announce
					var doDoubleClick = function(){
						_this.onDoubleClick();
						_this.broadcastMessage( "onDoubleClick" );
						// wait to enable double-clicking again
						_global.clearTimeout( _this.delay );
						_this.delay = _global.setTimeout( function(){
							_this.timeOut();
						}, _this.maxDelay );		// calls timeOut() 1/4 of a second later
					}// doDoubleClick()
					_global.setTimeout( function(){
						doDoubleClick();
					}, 1 );
				}// if:  near the location of the 1st click
			}// if:  2nd click
		}// if:  target clicked
		else
		{// if: target not clicked
			clickCount = 0;
		}// if: target not clicked
	}// click()
	
	
	
	function timeOut()
	{
		// _this   is needed because this function is called by setTimeout(),   a _global function which has NO access to this class's variables!   
		// ...so a reference is needed to access them.
		clickCount = 0;
	}// timeOut()
}// DoubleClick
